//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration
{
	/// <summary>
	/// Represents a null configuration source that always returns null for a section.
	/// </summary>
	public class NullConfigurationSource : IConfigurationSource
	{
		/// <summary>
		/// Returns null for the section.
		/// </summary>
		/// <param name="sectionName">The section name to retrieve.</param>
		/// <returns>Always <see langword="null"/>.</returns>
		public object GetSection(string sectionName)
		{
			return null;
		}
	}
}
